<?php

namespace Onestartup\Shop\Model;

use Illuminate\Database\Eloquent\Model;

class OrderTracking extends Model
{
	protected $table = 'order_trackings';
	protected $fillable = [
		'type',
		'detail',
		'sale_id',
		'user_id'
	];

	public function user()
	{
		return $this->belongsTo('App\User', 'user_id');
	}

	public function sale()
	{
		return $this->belongsTo('Onestartup\Shop\Model\SaleShop', 'sale_id');
	}
}
