<?php

namespace Onestartup\Shop\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

use Onestartup\Shop\Model\ProductShop as Product;

class StockNotify extends Notification
{
    use Queueable;

    protected $product;
    

    

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Product $product)
    {
        $this->product = $product;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->greeting('Hola apreciable administrador')
            ->subject('Verificar existencia de producto: '.$this->product->name)   
            ->line('El producto '.$this->product->name.' esta agotado o proximo a agotarse')
            ->line('Verifica la existencia del producto y actualiza su información')
            ->action('Ver producto', route('admin.shop.product.edit', $this->product->id));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
