@extends('crm-admin::main-layout')

@section('content')
@php
setlocale(LC_MONETARY, 'en_US');
@endphp

<div class='row'>
  <div class='col-md-12 collapse' id='agregarCategoria'>
    <div class='box'>
      <div class='box-header dark'>
        <h2>
          Agregar nueva promoción
          <span></span>
          <a aria-expanded='false' class='btn btn-xs btn-danger button-ml' data-toggle='collapse' href='#agregarCategoria'>
            Cancelar
          </a>
        </h2>
      </div>
      <div class='box-body'>
        <div class='col-md-12'>
          {!! Form::open(['route'=> 'admin.shop.coupon.store','method'=>'POST']) !!}
          @include('shop::coupon.fields')
          <div class='form-group'>
            <button class='btn btn-primary' type='submit'>
              Registrar
            </button>
          </div>
          {!! Form::close() !!}
        </div>
      </div>
    </div>
  </div>
  <div class='col-md-12'>
    <div class='box'>
      <div class='box-header dark'>
        <h2>
          Listado de promociones
          <span>
            <a aria-expanded='false' class='btn btn-xs btn-info button-ml' data-toggle='collapse' href='#agregarCategoria'>
              <i class='fas fa-plus'></i>
              Agregar nueva
            </a>
          </span>
        </h2>
      </div>
      <div class='box-body'>
        <div class='col-md-12'>
          <table class='table'>
            <tr>
              <th>#</th>
              <th>Promocion</th>
              <th>Cupon</th>
              <th>Valor</th>
              <th></th>
            </tr>
            @foreach ($coupons as $coupon)
            <tr>
              <td> {{$coupon->id}}</td>
              <td>
                <p>Nombre: <b>{{$coupon->name}}</b></p>
                <p>
                  Codigo:
                  <b> {{$coupon->code}}</b>
                </p>
              </td>
              <td>
                Tipo: 
                <b>{{$coupon->type}}</b><br>
                Expiracion: 
                <b>{{$coupon->expiration}}</b>
              </td>
              <td> 
                Descuento: 
                <b>
                @if($coupon->type == 'Efectivo')
                  {{money_format('%(#10n', $coupon->value)}}
                @endif

                @if($coupon->type == 'Porcentaje')
                  % {{$coupon->value}}
                @endif
                </b>
                <br>
                Compra minima: 
                <b>
                  {{money_format('%(#10n', $coupon->min_sale)}}
                </b>

               
              </td>
              <td>
                {!! Form::open(['route'=> ['admin.shop.coupon.destroy',$coupon->id],'method'=>'DELETE'])!!}
                <button class='btn btn-danger btn-xs button-mb' onclick="return confirm('¿Estás seguro de eliminar este elemento?');" type='submit'>
                  <i class='fas fa-trash-alt icon-special-size'></i>
                  Eliminar
                </button>
                {!! Form::close()!!}
                <a class='btn btn-xs accent' href="{{route('admin.shop.coupon.edit', $coupon->id)}}">
                  <i class='fas fa-edit icon-special-size'></i>
                  Editar
                </a>
              </td>
              @endforeach
            </tr>
          </table>
        </div>
      </div>
      <div class='dker p-a text-right'>
        {{ $coupons->links() }}
      </div>
    </div>
  </div>
</div>
@endsection
