@php
setlocale(LC_MONETARY, 'en_US');
@endphp

@component('mail::message')

# Resumen de la compra

@component('mail::panel')
-  Numero de orden: # {{$order->id}}
-  Fecha: {{$order->created_at->format('d/m/Y')}}
-  Forma de pago: {{$order->payment_type}}
@endcomponent


@component('mail::table')

| Cantidad       | Producto         | Precio  | Subtotal |
| :-------------: |:-------------:| :--------:| :-------:|
@foreach($products as $p)
| {{$p->pivot->quantity}}     | {{$p->name}}     | {{money_format('%(#10n', $p->infoSale->sale_price)}}    | {{money_format('%(#10n', $p->infoSale->sale_price * $p->pivot->quantity)}} |
@endforeach
| 1 | {{$shipping->shipping_price->name}}   | {{money_format('%(#10n',$shipping->shipping_price->cost)}}   | {{money_format('%(#10n',$shipping->shipping_price->cost)}} |
| - | - | Total:  | {{money_format('%(#10n',$order->total)}}| 

@endcomponent

@component('mail::panel')
Datos del comprador:

-  Nombre: *** {{$client->name}} {{$client->lastname}} ***
-  Teléfono: *** {{$client->phone}} ***
-  Correo: *** {{$client->email}} ***
@endcomponent

@component('mail::panel')
Datos de envio:

-  Calle: *** {{$shipping->calle}} Nro. {{$shipping->numero}}, col. {{$shipping->colonia}} ***
-  *** {{$shipping->ciudad}},  {{$shipping->estado}}, C.P. {{$shipping->cp}}***
-  Referencias: *** {{$shipping->referencias}} ***
-  Requiere factura: *** {{$shipping->facturacion}} ***
@endcomponent

Gracias por tu compra,<br>
{{ config('app.name') }}
@endcomponent
